function map = fir(varargin)
%An attempt to create my own colormap.  The design is based off the fire
%colormap in imageJ.
%Synatax:  map = fir(depth);
%Input: depth = The color depth of the map, e.g., 256 colors, 64 colors...
%Output: map = a 3xdepth array, where column 1 = red, 2 = green, 3 = blue.

if isempty(varargin)           %Set default for color depth if necessary
    depth = 256;
else
    depth = varargin{1,1};
end

map = zeros(depth,3);

for i = 1:depth
    map(i,1) = (round(depth/(1+exp(-(i-(depth*0.23))/(depth/15.0588)))))/depth;      %Set the red channel
    
    map(i,2) = (round(depth/(1+exp(-(i-(depth*0.605))/(depth/15.8514)))))/depth;  %Set the green channel
    
    if i<depth/2                            %Set the blue channel
        map(i,3) = (round((depth*sin(i/(depth/7.5294)))*0.859)/depth);
    else
        map(i,3) = (floor((depth*sin(i/(depth/7.5294)))*1.17)/depth);
    end
    
    if map(i,3)<0                          %Limit colors between 0 and depth or 1
        map(i,3) = 0;
    end
    if map(i,3)>1
        map(i,3) = 1;
    end
end